/*
RJEENJE:
Ideja zadatke je izraunati grupe meusobno povezanih
komponenti u grafu (meusobno povezanih gradova).

Gradove elimo podjeliti u grupe na nain da su svi 
gradovi unutar jedne grupe meusobno povezani.

Rjeenje zadataka je broj takvih grupa umanjen za jedan,
jer je za povezivanje K grupa potrebno je K-1 veza.

Zadatk rjeavamo osnovnim DFS (depth first search) algoritmom.
Prolazimo sve gradove i pokuamo posjetiti svaki neposjeeni
grad, pozivom funkcije Visit(). Funkcija Visit() rekurzivno posjeti
svu djecu nekog grada, odnosno sve gradove u koje se moe doi
iz poetnog grada.

Nakon posjeivanja sve djece nekog grada, posjetili smo jednu
grupu meusobno povezanih gradova. Traimo sljedei neposjeeni
grad, i kada ga pronaemo, i za njega pokrenemo funkciju Visit().
Pronalaskom drugog grada pronali smo i drugu grupu. Postupak je
potrebno ponoviti sve dok ne posjetimo sve gradove.
*/

#include <iostream>

using namespace std;

int N, K;
bool roads[1000][1000] = {false};
bool visited[1000] = {false};

void Visit (int city)
{
	visited[city] = true;

	for (int i=0; i<N; i++)
	{
		if (city != i && roads[city][i] && !visited[i])
		{
			Visit(i);
		}
	}
}

int main ()
{
	cin >> N >> K;
	
	for (int i=0; i<K; i++)
	{
		int a,b;

		cin >> a >> b;
		--a; --b;

		roads[a][b] = roads[b][a] = true;
	}

	int sets = 0;

	for (int i=0; i<N; i++)
	{
		if (!visited[i])
		{
			++sets;

			Visit(i);
		}
	}

	cout << sets-1 << endl;
}